// Copyright © 2007. Adobe Systems Incorporated. All Rights Reserved.
package fl.motion
{
/**
 * The Tweenables class provides constant values for the names of animation properties used in the MotionBase and KeyframeBase classes.  
 * @playerversion Flash 9.0.28.0
     * @playerversion AIR 1.0
     * @productversion Flash CS3
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript    
 * @see ../../motionXSD.html Motion XML Elements   
 * @see fl.motion.MotionBase
 * @see fl.motion.KeyframeBase
 */
public class Tweenables
{
    /**
     * Constant for the <code>x</code> property.
     * @playerversion Flash 9.0.28.0
     * @playerversion AIR 1.0
     * @productversion Flash CS3
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript       
     * @see fl.motion.KeyframeBase#x
     */
    public static const X:String = 'x';



    /**
     * Constant for the <code>y</code> property.
     * @playerversion Flash 9.0.28.0
     * @playerversion AIR 1.0
     * @productversion Flash CS3
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.KeyframeBase#y
     */
    public static const Y:String = 'y';


    /**
     * Constant for the <code>z</code> property.
     * @playerversion Flash 10
     * @playerversion AIR 1.0
     * @productversion Flash CS3
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.KeyframeBase#z
     */
     public static const Z:String = 'z';
     

    /**
     * Constant for the <code>scaleX</code> property.
     * @playerversion Flash 9.0.28.0
     * @playerversion AIR 1.0
     * @productversion Flash CS3
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.KeyframeBase#scaleX
     */
    public static const SCALE_X:String = 'scaleX';



    /**
     * Constant for the <code>scaleY</code> property.
     * @playerversion Flash 9.0.28.0
     * @playerversion AIR 1.0
     * @productversion Flash CS3
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.KeyframeBase#scaleY
     */
    public static const SCALE_Y:String = 'scaleY';



    /**
     * Constant for the <code>skewX</code> property.
     * @playerversion Flash 9.0.28.0
     * @playerversion AIR 1.0
     * @productversion Flash CS3
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.KeyframeBase#skewX
     */
    public static const SKEW_X:String = 'skewX';



    /**
     * Constant for the <code>skewY</code> property.
     * @playerversion Flash 9.0.28.0
     * @playerversion AIR 1.0
     * @productversion Flash CS3
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.KeyframeBase#skewY
     */
    public static const SKEW_Y:String = 'skewY';


    /**
     * Constant for the <code>rotation</code> property.
     * @playerversion Flash 9.0.28.0
     * @playerversion AIR 1.0
     * @productversion Flash CS3
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.KeyframeBase#rotation
     */
	public static const ROTATION:String = 'rotation';
	
    /**
     * Constant for the <code>rotationX</code> property.
     * @playerversion Flash 10
     * @playerversion AIR 1.0
     * @productversion Flash CS3
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.KeyframeBase#rotationX
     */
	public static const ROTATION_X:String = 'rotationX';
	
	
    /**
     * Constant for the <code>rotationY</code> property.
     * @playerversion Flash 10
     * @playerversion AIR 1.0
     * @productversion Flash CS3
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.KeyframeBase#rotationY
     */
	public static const ROTATION_Y:String = 'rotationY';


    /**
     * Constant for the <code>rotationConcat</code> property.
     * @playerversion Flash 10
     * @playerversion AIR 1.0
     * @productversion Flash CS3
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.KeyframeBase#rotationConcat
     */
	public static const ROTATION_CONCAT:String = 'rotationConcat';
}
}